#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// star streetMod01.fsh by jorge2017a2
//https://www.shadertoy.com/view/7sKGWW
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//----------image
//por jorge2017a1-
#define MAX_STEPS 100
#define MAX_DIST 100.
#define MIN_DIST 0.001
#define EPSILON 0.001
#define REFLECT 2
//==common-==//
//----------common
///------------------------------------
struct TObj
{
    float id_color;
    float id_objeto;
    float id_material;
    float dist;
    vec3 normal;
    vec3 ro;
    vec3 rd;
    vec2 uv;
    vec3 color;
    vec3 p;
    vec3 phit; //22-mar-2021
    vec3 rf;
    float marchCount;
    bool blnShadow;
    bool hitbln;
};

    
TObj mObj;
vec3 glpRoRd;
vec2 gres2;
float itime;

#define PI 3.14159265358979323846264
#define MATERIAL_NO -1.0
#define COLOR_NO -1.0
#define COLORSKY vec3(0.1, 0.1, 0.6)

///Gracias a SHane...16-jun-2020
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){    
    n = max(n*n - .2, .001); // max(abs(n), 0.001), etc.
    n /= dot(n, vec3(1)); 
    vec3 tx = texture2D(tex, p.yz).xyz;
    vec3 ty = texture2D(tex, p.zx).xyz;
    vec3 tz = texture2D(tex, p.xy).xyz;
    return mat3(tx*tx, ty*ty, tz*tz)*n; 
}

vec3  Arrcolores[] = vec3[] (
vec3(0,0,0)/255.0,  //0
vec3(255.,255.,255.)/255.0, //1
vec3(255,0,0)/255.0,  //2
vec3(0,255,0)/255.0,   //3
vec3(0,0,255)/255.0,   //4
vec3(255,255,0)/255.0,  //5
vec3(0,255,255)/255.0,  //6 
vec3(255,0,255)/255.0,   //7
vec3(192,192,192)/255.0,  //8
vec3(128,128,128)/255.0,  //9
vec3(128,0,0)/255.0,   //10
vec3(128,128,0)/255.0,  //11
vec3(0,128,0)/255.0,   //12
vec3(128,0,128)/255.0,  //13
vec3(0,128,128)/255.0,  //14
vec3(0,0,128)/255.0,    //15
vec3(255, 204, 188)/255.0,  //16
vec3(0.8, 0.8, 0.8),  //17
vec3(0.5, 0.5, 0.8),  //18
vec3(1, 0.5, 0),      //19
vec3(1.0, 1.0, 1.0),  //20
vec3(247./255., 168./255.,  184./255.),  //21
vec3(0, 1, 1),                           //22 
vec3(85./255., 205./255., 252./255.),    //23
vec3(0.425, 0.56, 0.9)*vec3( 0.3, 0.2, 1.0 ),  //24 
vec3(0.8,0.8,0.8)*vec3( 0.3, 0.2, 1.0 ),       //25  
vec3(1.0,0.01,0.01)*vec3( 0.3, 0.2, 1.0 ),     //26
vec3(0.1, 0.5, 1.0),                           //27   
vec3(0.0, 0.6, 0.0),                       //28 
vec3(0.1,0.1,0.7),                          //29
vec3(0.99, 0.2, 0.1), //30
vec3(.395, .95, 1.), //31
vec3(0.425, 0.56, 0.9) 
);

//----------------------------------------------------
vec3 getColor(int i)
{    
    if (i==-2 ) {return mObj.color; }       
    if (i>-1 ) 
		return Arrcolores[i];
}
///--------------------------------------------

//==end common==//


//tips and cooperation by ocb and spalmer


vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 GetColorYMaterialv1(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 GetColorYMaterialv2(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);

vec3 getMaterial( vec3 pp, float id_material);
vec3 light_pos1;  vec3 light_color1 ;
vec3 light_pos2;  vec3 light_color2 ;

//operacion de Union  por FabriceNeyret2
#define opU3(d1, d2) ( d1.x < d2.x ? d1 : d2 )
#define opU(d1, d2) ( d1.x < d2.x ? d1 : d2 )


float sdBox( vec3 p, vec3 b )
	{ vec3 d = abs(p) - b;   return length(max(d,0.0))+ min(max(d.x,max(d.y,d.z)),0.0); }
float intersectSDF(float distA, float distB)
	{ return max(distA, distB);}
float unionSDF(float distA, float distB)
	{ return min(distA, distB);}
float differenceSDF(float distA, float distB)
	{ return max(distA, -distB);}
float opRep1D( float p, float c )
	{ float q = mod(p+0.5*c,c)-0.5*c; return  q ;}
vec3 rotate_x(vec3 p, float phi)
{   float c = cos(phi);	float s = sin(phi);
    return vec3(p.x, c*p.y - s*p.z, s*p.y + c*p.z);
}
vec3 rotate_y(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x + s*p.z, p.y, c*p.z - s*p.x);
}
vec3 rotate_z(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x - s*p.y, s*p.x + c*p.y, p.z);
}
///------------------------------------

float sdStar5(in vec2 p, in float r, in float rf)
{
    const vec2 k1 = vec2(0.809016994375, -0.587785252292);
    const vec2 k2 = vec2(-k1.x,k1.y);
    p.x = abs(p.x);
    p -= 2.0*max(dot(k1,p),0.0)*k1;
    p -= 2.0*max(dot(k2,p),0.0)*k2;
    p.x = abs(p.x);
    p.y -= r;
    vec2 ba = rf*vec2(-k1.y,k1.x) - vec2(0,1);
    float h = clamp( dot(p,ba)/dot(ba,ba), 0.0, r );
    return length(p-ba*h) * sign(p.y*ba.x-p.x*ba.y);
}

vec3 estrella(vec3 p, float idcol1, float idcol2)
{	
    vec3 res= vec3(9999.0, -1.0,-1.0);  
    float sdb1= sdBox(p, vec3(12.0,12.0,10.0) );
    
    float r1=3.0;
    float rf1=3.0;
    
    float r2=2.5;
    float rf2=3.0;
    
    vec3 p1=p;
    p1= rotate_y(p1, radians(90.0));
    p1= rotate_z(p1, radians(90.0));
    p1= rotate_y(p1, radians(54.0));
    
    float sds1= sdStar5(p1.xz,r1, rf1);
    float sds2= sdStar5(p1.xz,r2, rf2);
    
    float sinte= intersectSDF(sdb1, sds1);
    float sinte2= intersectSDF(sdb1, sds2);
    res =opU3(res, vec3(sinte,idcol1,-1.0));
    res =opU3(res, vec3(sinte2,idcol2,-1.0));

    return res;
}


vec3 GetDist(vec3 p  ) 
{	vec3 res= vec3(9999.0, -1.0,-1.0);  vec3 pp=p;
	float planeDist1 = p.y+0.0;  //piso inf
    p.x= opRep1D(p.x, 65.0 );
    
    float sdb1= sdBox(p-vec3(0.0,12.0,0.0), vec3(50.0,25.0,1.0) );
    float sdb2= sdBox(p-vec3(0.0,-5.0,0.0), vec3(50.0,1.0,25.0) );
    float sdb3= sdBox(p-vec3(0.0,-4.0,0.0), vec3(50.0,6.0,20.0) );
    p.y=p.y-10.0;
    
    vec3 es1= estrella( p-vec3( 20.0,5.0,3.0), 2.0, 3.0);
    vec3 es2= estrella( p-vec3(  0.0,10.0,-1.0), 5.0, 4.0);
    vec3 es3= estrella( p-vec3(-20.0,5.0,3.0), 6.0, 7.0);
    res =opU3(res, es1);
    res =opU3(res, es2);
    res =opU3(res, es3);
    res =opU3(res, vec3(sdb1,101.0,-1.0));
    res =opU3(res, vec3(sdb2,101.0,-1.0));
    res =opU3(res, vec3(sdb3,100.0,-1.0));
   
    return res;
}

//------------------------------------------------
vec3 GetNormal(vec3 p)
{   float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(GetDist(p-e.xyy).x,GetDist(p-e.yxy).x,GetDist(p-e.yyx).x);
    return normalize(n);
}

float RayMarch(vec3 ro, vec3 rd, int PMaxSteps)
{   float t = 0.; 
    vec3 dS=vec3(9999.0,-1.0,-1.0);
    float marchCount = 0.0;
    vec3 p;
    float minDist = 9999.0; 
    
    for(int i=0; i <= PMaxSteps; i++) 
    {  	p = ro + rd*t;
        dS = GetDist(p);
        t += dS.x;
        if ( abs(dS.x)<MIN_DIST  || i == PMaxSteps)
            {mObj.hitbln = true; minDist = abs(t); break;}
        if(t>MAX_DIST)
            {mObj.hitbln = false;    minDist = t;    break; } 
        marchCount++;
    }
    mObj.dist = minDist;
    mObj.id_color = dS.y;
    mObj.marchCount=marchCount;
    mObj.id_material=dS.z;
    mObj.normal=GetNormal(p);
    mObj.phit=p;
    return t;
}


float occlusion(vec3 pos, vec3 nor)
{
    float sca = 2.0, occ = 0.0;
    for(int i = 0; i < 10; i++) {
    
        float hr = 0.01 + float(i) * 0.5 / 4.0;        
        float dd = GetDist(nor * hr + pos).x;
        occ += (hr - dd)*sca;
        sca *= 0.6;
    }
    return clamp( 1.0 - occ, 0.0, 1.0 );    
}

vec3 lightingv3(vec3 normal,vec3 p, vec3 lp, vec3 rd, vec3 ro,vec3 col, float t) 
{   
    vec3 lightPos=lp;
    vec3 hit = ro + rd * t;
    vec3 norm = GetNormal(hit);
    
    vec3 light = lightPos - hit;
    float lightDist = max(length(light), .001);
    float atten = 1. / (1.0 + lightDist * 0.125 + lightDist * lightDist * .05);
    light /= lightDist;
    
    float occ = occlusion(hit, norm);
    
    float dif = clamp(dot(norm, light), 0.0, 1.0);
    dif = pow(dif, 4.) * 2.;
    float spe = pow(max(dot(reflect(-light, norm), -rd), 0.), 8.);
    
    vec3 color = col * (dif + .35  + vec3(.35, .45, .5) * spe) + vec3(.7, .9, 1) * spe * spe;
    
    return color;
    
    
    
}
//----------------------------------------------------
vec3 getColorTextura( vec3 p, vec3 nor,  int i)
{	
    float es=65.0; //32.0
    if (i==100 )
    { vec3 col=tex3D(texture0, p/es, nor); return col; }
	if (i==101 ) { return tex3D(texture1, p/es, nor); }
	if (i==102 ) { return tex3D(texture2, p/es, nor); }
	if (i==103 ) { return tex3D(texture3, p/es, nor); }
}
//-------------------------------
vec3 Getluz(vec3 p, vec3 ro, vec3 rd, vec3 nor , vec3 colobj ,vec3 plight_pos, float tdist)
{  float intensity=1.0;
     vec3 result;
    result = lightingv3( nor, p, plight_pos,  rd,ro, colobj, tdist);
    return result;
}

vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material)
{  	vec3 colobj; 
    
    float t1=mod(iTime+1.5,4.0);
    float t2=mod(iTime+3.0,5.0);
    
    if (t1<t2)
    colobj= GetColorYMaterialv1(p, n, ro, rd,id_color,  id_material);
    else
    colobj= GetColorYMaterialv2(p, n, ro, rd, id_color, id_material);
    
    return colobj;
}



vec3 GetColorYMaterialv1(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material)
{  	vec3 colobj; 
    if (id_color<100)
		//{ colobj=getColor(int( id_color)); }
        { colobj=getColor(id_color+int(mod(iTime,31.)));}
    
    if ( float( id_color)>=100.0  && float( id_color)<=199.0 ) 
 	{  vec3 coltex=getColorTextura(p, n, int( id_color));
        colobj=coltex*clamp(  0.8+0.5*sin(iTime*0.5),  0.,1.0);
	}

    return colobj;
}

vec3 GetColorYMaterialv2(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material)
{  	vec3 colobj;

    int colswitch = int(mod(iTime,31.));    // preset because it is used many time
    
    if (id_color<100)
        { colobj=getColor(id_color+colswitch);}
    
    if ( float( id_color)>=100.0  && float( id_color)<=199.0 ) 
 	{  vec3 coltex=getColorTextura(p, n, int( id_color));
        colobj=.3*coltex*clamp(  0.8+0.3*sin(iTime*0.5),  0.,1.0);   // .3* = darken wall to increase light effect
        
        
        p.x= opRep1D(p.x, 65.0 );
        float d1 = length(vec2(p.x-20., p.y-14.));    // calculating distance from each star center
        float d2 = length(vec2(p.x    , p.y-19.));
        float d3 = length(vec2(p.x+20., p.y-14.));
        
        float d4 = length(vec2(p.x-45., p.y-14.));    // tricky: used to mix color with the previous and next three stars group
        float d5 = length(vec2(p.x+45., p.y-14.));
        
        float amount=20.0;//10.0
        colobj += amount/(d1*d1)*getColor(2+colswitch)   // affecting each coresponding color related to the star and to the distance 1/(d*d)
                 +min(20./(d2*d2)*getColor(5+colswitch),.4)
                 +amount/(d3*d3)*getColor(6+colswitch)
                 
                 +amount/(d4*d4)*getColor(6+colswitch)   // mixing with the next group of three stars
                 +amount/(d5*d5)*getColor(2+colswitch);  // comment this two lines to see the difference
	}

    return colobj;
}



vec3 Render(vec3 ro, vec3 rd)
{  vec3 col = vec3(0);
   TObj Obj;
   mObj.rd=rd;
   mObj.ro=ro;
   vec3 p;

     float d=RayMarch(ro,rd, MAX_STEPS);
   
    Obj=mObj;
    if(mObj.hitbln) 
    {   p = (ro + rd * d );  
        vec3 nor=mObj.normal;
        vec3 colobj;
        colobj=GetColorYMaterial( p, nor, ro, rd,  int( Obj.id_color), Obj.id_material);

        float dif1=1.0;
        vec3 result;
        result=  Getluz( p,ro,rd, nor, colobj ,light_pos1,d);
        result+= Getluz( p,ro,rd, nor, colobj ,light_pos2,d);
   
        col= result;
    }
   
   return col;
}

///---------------------------------------------
vec3 linear2srgb(vec3 c) {
    return mix(
        12.92 * c,1.055 * pow(c, vec3(1.0/1.8)) - 0.055,
        step(vec3(0.0031308), c));
}

vec3 exposureToneMapping(float exposure, vec3 hdrColor) 
{    return vec3(1.0) - exp(-hdrColor * exposure);  }

///---------------------------------------------

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{   vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
   mObj.uv=uv;
    float t;
    t=mod(iTime*10.0,520.0);
    itime=t;
	//mObj.blnShadow=false;
    mObj.blnShadow=true;
        
 	light_pos1= vec3(50.0, 260.0, -30.0 ); light_color1=vec3( 1.0 );
 	light_pos2= vec3( -100.0, -940.0,30.0 ); light_color2 =vec3( 1.0 ); 
 
   
   vec3 ro=vec3(0.0-t,35.0,-25.0);
   vec3 rd=normalize( vec3(uv.x,uv.y,1.0));
   rd= rotate_x(rd, radians(45.0));
   rd= rotate_y(rd, radians(-20.0));
   
    light_pos1+=ro;
    light_pos2+=ro;
    vec3 col= Render( ro,  rd);
    //col = exposureToneMapping(2.0, col);
    col = linear2srgb(col);
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

